package gov.va.vamf.scheduling.direct.datalayer.notification;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import gov.va.vamf.scheduling.direct.datalayer.appointment.PatientIdentifiersDataService;
import gov.va.vamf.scheduling.direct.domain.InAppMessage;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Component
@Service
public class NotificationDataService {

    @Value("${vmm.inapp.notification.fetch.uri}")
    private String vmmInAppNotificationFetchUri;

    @Value("${vmm.inapp.notification.mark.read}")
    private String vmmInAppNotificationMarkReadUri;

    @Value("${vmm.inapp.notification.delete.uri}")
    private String vmmInappNotificationDeleteUri;

    @Resource
    PatientIdentifiersDataService patientIdentifiersDataService;

    public List<InAppMessage> fetchNotifications(PatientIdentifier edipiPatientIdentifier) {

        PatientIdentifier icnPatientIdentifier = edipiPatientIdentifier;

        Map<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("assigningAuthority", icnPatientIdentifier.getAssigningAuthority());
        pathParams.put("uniqueId", icnPatientIdentifier.getUniqueId());

        URI uri = buildUri(vmmInAppNotificationFetchUri, pathParams);

        return getRestClient()
            .target(uri)
            .request()
            .accept(MediaType.APPLICATION_JSON)
            .get(new GenericType<List<InAppMessage>>() {});
    }

    public void setNotificationAsRead(String messageIdentifier) {
        Map<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("messageIdentifer", messageIdentifier);

        URI uri = buildUri(vmmInAppNotificationMarkReadUri, pathParams);

        getRestClient()
                .target(uri)
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .put(Entity.entity(new InAppMessage(), MediaType.APPLICATION_JSON));
    }

    public void deleteNotification(String messageIdentifier) {
        Map<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("messageIdentifer", messageIdentifier);

        URI uri = buildUri(vmmInappNotificationDeleteUri, pathParams);

        getRestClient()
                .target(uri)
                .request()
                .delete();
    }

    private Client getRestClient() {
        return ClientBuilder.newBuilder().build();
    }

    private URI buildUri(String url, Map<String, String> pathParams) {
        return UriBuilder.fromUri(url).buildFromMap(pathParams);
    }
}
